function img = flatview2(stk,varargin)
%This little diddy allows the user to take a stack of images and flatten it
%into in image.  Per pixel arithmatic is applied to the stack to create the
%final image.
%Synatax: img = flatview2(stk,'style','range_extend');
%Input: stk = The image stack, preferably from the "stack" function.
%
%       STYLE = The type of image arithmatic used to create the final
%       image.  The available styles are: 
%       'mean' = The mean image.
%       'median' = The median image (Default).
%       'max' = The max image, which uses the max pixel intensity in the
%       stack for each pixel.
%       'min' = The min image, reverse of above.
%       'sum' = The sum of all pixels. Note: sum returns an image in uint16
%       format).
%       'difference' = the diffrence of the lowest 10% of the values of a 
%       pixel as the versus the highest 10% of value for that pixel)
%       'std'= Image composed of the standard deviation of each pixel
%       through the stack.
%       'var' = Image composed of the variance of each pixel through the
%       stack.
%
%       'range_extend' = Extend the current image dynamic range
%       over the entire possible range.
%Output: img = the flattened image.

if isempty(varargin)
    img = median(stk,3);                 %Median value flatten is the default
else
    a = size(varargin);
    for i = 1:a(1,2)
        switch varargin{1,i}
            case 'median'                       %Median value flatten
                img = median(stk,3);
            case 'mean'                         %Mean value flatten
                img = mean(stk,3);
            case 'max'                          %Max value flatten
                img = max(stk,[],3);
            case 'min'                          %Min value flatten
                img = min(stk,[],3);
            case 'std'                          %Standard Deviation value flatten
                img = std(double(stk),0,3);
            case 'var'                          %Value Variance flatten
                img = var(double(stk),0,3);
            case 'sum'                          %Sum of all values flatten
                img = sum(stk,3);
            case 'difference'                   %difference value flatten
                b = size(stk);
                sorted_stk = sort(stk,3,'ascend');  %Sort the values of the stack so that the lowest is on top (:,:,1)
                base_mtrx = mean(sorted_stk(:,:,1:ceil(b(1,3)*0.1)),3);  %The baseline matrix is the mean of the lowest 10% of values
                data_mtrx = mean(sorted_stk(:,:,ceil(b(1,3)*0.05):b(1,3)),3); %The data matrix used here is the mean of the highest 10% of values
                img = data_mtrx-base_mtrx;
            case 'range_extend'
                img = imnorm(img);
            otherwise
                error(['You entered an invalid parameter.'])
        end
    end
end